#define _GNU_SOURCE

#include <sys/stat.h>
#include <dlfcn.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

static const char *blocked[] =
	{
		"/opt/Adobe/Reader9/Reader/intellinux/plug_ins/PPKLite.api",
		"/opt/Adobe/Reader9/Reader/intellinux/plug_ins/DigSig.api"
	};

static int isBlocked(const char *path) {
	int i;
	for(int i=0; i < sizeof(blocked) / sizeof(blocked[0]); i++) {
		if(!strcmp(path, blocked[i])) {
			return 1;
		}
	}
	return 0;
}

int __xstat(int ver, const char *path, struct stat *statbuf) {
	if(isBlocked(path)) {
		errno = ENOENT;
		return -1;
	}
	int (*real)(int ver, const char *, struct stat *) =
		dlsym(RTLD_NEXT, "__xstat");
	return real(ver, path, statbuf);
}

int access(const char *path, int mode) {
	if(isBlocked(path)) {
		errno = ENOENT;
		return -1;
	}
	int (*real)(const char *, int mode) =
		dlsym(RTLD_NEXT, "access");
	return real(path, mode);

}
